/* Capteur capacitif:
Version française de Capacitive Sensing
*/

/*Capactive Sensing
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 2 10M Ohm resistors

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.  
 */

#include <CapacitiveSensor.h>

// Les broches utilisées par le capteur
int brocheCapteur = 2;
int brocheSignal = 4;

CapacitiveSensor capteurTactile = CapacitiveSensor(brocheSignal,brocheCapteur);

void setup() {
  // initialiser une communication série
  Serial.begin(9600);
}

void loop() {
  // lire les données retournées par le capteur
  long valeurCapteur = capteurTactile.capacitiveSensor(30);
  // afficher la valeur
  Serial.println(valeurCapteur);
  // faire une courte pause avant de continuer
  delay(10);
}
